/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsByteStream;
import com.ibm.hsc.filesvr.FsConnection;
import com.ibm.hsc.filesvr.FsException;
import com.ibm.hsc.filesvr.FsFileDescriptor;
import com.ibm.hsc.filesvr.FsFileListPacket;
import com.ibm.hsc.filesvr.FsFileListRequestPacket;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public class FsFileListResponsePacket
extends FsFileListPacket {
    protected Hashtable m_fileListHash = new Hashtable();
    protected TreeMap m_fileListMap = new TreeMap();

    protected FsFileListResponsePacket(FsConnection fsConnection) {
        super(fsConnection);
    }

    public FsFileListResponsePacket(FsFileListRequestPacket fsFileListRequestPacket) {
        super(fsFileListRequestPacket);
        this.setResponsePacket();
        this.m_filter = fsFileListRequestPacket.getFileFilter();
    }

    protected void buildData(FsByteStream fsByteStream) throws FsException {
        super.buildData(fsByteStream);
        if (!this.isResponsePacket()) {
            throw new FsException(20);
        }
        try {
            FsFileDescriptor fsFileDescriptor;
            String string;
            this.m_fileListHash = this.m_connection.getFileList(this.m_filter);
            Enumeration enumeration = this.m_fileListHash.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                fsFileDescriptor = (FsFileDescriptor)this.m_fileListHash.get(string);
                GregorianCalendar gregorianCalendar = fsFileDescriptor.getDate();
                if (gregorianCalendar == null) continue;
                this.m_fileListMap.put(gregorianCalendar.getTime(), fsFileDescriptor);
            }
            int n = this.getFileListFormat();
            fsByteStream.writeInt(this.m_fileListMap.size());
            Iterator iterator = this.m_fileListMap.keySet().iterator();
            while (iterator.hasNext()) {
                fsFileDescriptor = (FsFileDescriptor)this.m_fileListMap.get(iterator.next());
                string = fsFileDescriptor.getName();
                fsByteStream.writeInt(1, 1);
                fsByteStream.writeLong(string.length(), 7);
                fsByteStream.writeString(string);
                if (n == 2) {
                    fsByteStream.writeInt(2, 1);
                    fsByteStream.writeLong(fsFileDescriptor.getSize(), 7);
                    continue;
                }
                if (n != 3) continue;
                fsByteStream.writeInt(2, 1);
                fsByteStream.writeLong(fsFileDescriptor.getSize(), 7);
                fsByteStream.writeInt(3, 1);
                fsByteStream.writeDate(fsFileDescriptor.getDate());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new FsException(1);
        }
    }

    public int getNumFiles() {
        return this.m_fileListHash.size();
    }

    public Hashtable getFileListHash() {
        return new Hashtable(this.m_fileListHash);
    }

    public void printFileListInfo() {
        this.m_connection.traceFileList("FsFileListResponsePacket.printFileListInfo: File list", this.m_fileListMap);
    }

    protected void parseData(FsByteStream fsByteStream) throws FsException {
        super.parseData(fsByteStream);
        if (!this.isResponsePacket()) {
            throw new FsException(20);
        }
        int n = this.getFileListFormat();
        int n2 = 1;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n == 2) {
            bl2 = true;
            n2 = 2;
        } else if (n == 3) {
            bl2 = true;
            bl3 = true;
            n2 = 3;
        }
        int n3 = fsByteStream.readInt();
        this.m_fileListHash.clear();
        for (int i = 0; i < n3; ++i) {
            String string = null;
            long l = 0L;
            GregorianCalendar gregorianCalendar = null;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            block6: for (int j = 0; j < n2; ++j) {
                byte by = fsByteStream.readByte();
                switch (by) {
                    case 1: {
                        bl4 = true;
                        int n4 = (int)fsByteStream.readLong(7);
                        string = fsByteStream.readString(n4);
                        continue block6;
                    }
                    case 2: {
                        bl5 = true;
                        l = fsByteStream.readLong(7);
                        continue block6;
                    }
                    case 3: {
                        bl6 = true;
                        gregorianCalendar = fsByteStream.readDate();
                        continue block6;
                    }
                    default: {
                        throw new FsException(25, by);
                    }
                }
            }
            if (bl4 != bl) {
                throw new FsException(26, (long)n, 1L);
            }
            if (bl5 != bl2) {
                throw new FsException(26, (long)n, 2L);
            }
            if (bl6 != bl3) {
                throw new FsException(26, (long)n, 3L);
            }
            this.m_fileListHash.put(string, new FsFileDescriptor(string, l, gregorianCalendar));
        }
        this.m_fileListMap = new TreeMap(this.m_fileListHash);
    }
}

